module net.BurtonRadons.spyl.statement;

private import net.BurtonRadons.spyl.mark;
private import net.BurtonRadons.spyl.scope;
private import std.string;

class Statement
{
    Mark mark; /**< Marker start for the statement. */
    Statement next; /** The next statement or null. */
    
    /** Assign the mark. */
    this (Mark mark)
    {
        this.mark = mark;
    }
    
    /** Evaluate the statement, return the next statement to evaluate. */
    abstract Statement evaluate (Scope scope);
    
    void print ()
    {
        printf ("%.*s\n", toString ());
    }
    
    char [] toString ()
    {
        throw new Error (this.classinfo.name ~ ".toString () is not implemented.");
        return null;
    }
    
    char [] indent (char [] string, int amount)
    {
        char [] space = new char [amount];
        
        space [] = " ";
        string = space ~ string;
        replace (string, "\n", "\n" ~ space);
        return string;
    }
}

class ExpressionStatement : Statement
{
    private import net.BurtonRadons.spyl.expression;
    
    Expression expression; /**< The relevant expression. */
    
    this (Mark mark, Expression expression)
    {
        super (mark);
        this.expression = expression;
    }
    
    override Statement evaluate (Scope scope)
    {
        expression.evaluate (scope);
        return next;
    }
    
    override char [] toString ()
    {
        return expression.toString () ~ ";";
    }
}

/** A series of statements. */
class BlockStatement : Statement
{
    Statement [] content; /**< Statements. */
    
    this (Mark mark)
    {
        super (mark);
    }
    
    override Statement evaluate (Scope scope)
    {
        for (int c; c < content.length; c ++)
            content [c].evaluate (scope);
        return next;
    }
    
    void add (Statement child)
    {
        if (child === null)
            return;
        if (content.length)
            content [content.length - 1].next = child;
        content ~= child;
    }
    
    override char [] toString ()
    {
        char [] text;
        
        text = "{\n";
        for (int c; c < content.length; c ++)
            text ~= indent (content [c].toString (), 4) ~ "\n";
        return text ~ "}";
    }
}